# Separación de empresas
## Paso preeliminar
Haber ejecutado las migraciones que contengan las tablas **central_users**, **tenants** y **domains**. Para mas información, vea el directorio [Migraciones](database/migrations)

## 1. Ejecutar el comando setup-tenancy
Se necesitan mapear todos los usuarios de la base central a la arquitectura de multi-tenancy, por lo tanto, se necesitan entidades en las tablas tenants y domains. Para ello se debe ejecutar el siguiente comando en la raíz del proyecto:
```bash
php artisan setup-tenancy

# Nota 1: La base de datos utilizada en este comando es la que esta en la variable de entorno del archiv .env, ubicado en la raíz del proyecto.
# Nota 2: Si ya se hizo este paso en el entorno, no es necesario ejecutar este comando.
```

## 2. Crear las bases de datos (Opcional)
Es necesario haber creado la base de datos antes de migrar los datos. Si se tienen permisos admin para la creación de base de datos, entonces se puede ejecutar el siguiente comando en la raíz del proyecto para crear todas las bases de datos faltantes para el correcto funcionamiento de la multi-tenencia:
```bash
php artisan create-databases --db=La_BD_central

#Parámetros
#   - host= : El host del mysql (ejemplo: 127.0.0.1)
#   - user= : El usuario de la base de datos.
#   - password= : El password del usuario
#   - port= : El puerto del mysql (ejemplo: 3306)
#   - db= : Base de datos principal donde estan todos los datos
```

## 3. Configurar el esquema de la base datos a nivel tenencia
Para el esquema de la base de datos para cada tenant se require utilizar el siguiente comando en la raíz del proyecto:
```bash
php artisan tenants:migrate
```

## 4. Migrar los datos
Para migrar los datos a cada base de datos correspondientes del tenant se tiene que ejecutar el siguiente comando en la raíz del proyecto:

```bash
php artisan separar-datos-empresas --db=La_BD_central

#Parámetros
#   - host= : El host del mysql (ejemplo: 127.0.0.1)
#   - user= : El usuario de la base de datos.
#   - password= : El password del usuario
#   - port= : El puerto del mysql (ejemplo: 3306)
#   - db= : Base de datos principal donde estan todos los datos
#   - cs : Bandera para copiar estructura de la base de datos principal.
```

## 5. Configurar los triggers de los tenants
Para configurar los triggers de cada base de datos tenant, se tiene que ejecutar el siguiente comando en la raíz del proyecto:
```bash
php artisan setup-triggers --path=database/migrations/triggers

# Parámetros
#   - path= : Ruta del archivo de configuración de triggers
#   - rollback : Bandera para ejecutar down() (migrate:rollback)
#   - step= : Pasos a revertir con --rollback
```

## 6. Migrar imágenes
Al utilizar la arquitectura multi-tenant se cambio la gestión de las imágenes a tener carpetas separadas. Se necesita cambiar los datos actuales tanto en la carpeta storage como en la base de datos para la imagen del producto.

Para cambiar la cadena de la base de datos en la tabla productos se debe ejecutar el siguiente comando en la raíz del proyecto:
```bash

php artisan cambiar-cadena-tenants --table=cat_productos --column=imagen  --pattern="/empresa_[0-9]+/" --replace="/"   

# Parámetros
#   - table= : El nombre de la tabla a modificar.
#   - column= : El nombre de la columna a modificar.
#   - pattern= : Expresión regular para buscar en la cadena de la columna.
#   - replace= : El valor que reemplazará el valor buscado.
```

Para migrar la estructura actual de las imágenes en la carpeta storage se debe ejecutar el siguiente comando en la raíz del proyecto:
```bash

php artisan split-images --path= --to=productos

# Paramétros
#   - path= : La ruta de las imagenes a cambiar.
#   - to= : La ruta destino, dentro del directorio storage/tenant+\i/app/imagenes/. Por ejemplo, "-to=productos" el path destino es storage/tenant+\i/app/imagenes/productos/
```

