<?php

namespace App\Console\Commands;

use App\Models\Tenant;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

class CambiarCadenaTenants extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cambiar-cadena-tenants
    {--table= : The name of the table to modify}
    {--column= : The name of the column to modify}
    {--pattern= : The regex pattern to use for searching}
    {--replace= : The string to replace with}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $table = $this->option('table');
        $column = $this->option('column');
        $replace = $this->option('replace');
        $pattern = $this->option('pattern');

        if (!$table || !$column || !$replace || !$pattern) {
            $this->error('All options are required.');
            return;
        }

        Tenant::query()->cursor()->each(function (Tenant $tenant) use ($table, $column, $replace, $pattern) {
            $tenant->run(function () use ($tenant, $table, $column, $replace, $pattern) {
                DB::purge('tenant');
                DB::reconnect('tenant');

                $this->info("Conectado a la base de datos del tenant: {$tenant->id}");

                $sql = "UPDATE {$table}
                SET {$column} = REGEXP_REPLACE({$column}, '{$pattern}', '{$replace}')
                WHERE {$column} IS NOT NULL
                AND {$column} REGEXP '{$pattern}'";

                DB::statement($sql);

                $this->info("✅ Registros actualizados en la tabla '{$table}' del tenant: {$tenant->id} correctamente.");
            });
        });
    }
}
