<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class CreateDatabases extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'create-databases
    {--host= : El host del mysql (ejemplo: 127.0.0.1) }
    {--user= : El usuario de la base de datos.}
{--password= : El password del usuario}
{--port=3306 : El puerto del mysql (ejemplo: 3306)}
{--db= : Base de datos principal donde estan todos los datos}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $host = $this->option('host') ?? '127.0.0.1';
        $user = $this->option('user') ?? 'root';
        $pass = $this->option('password') ?? '';
        $mainDb = $this->option('db');
        $port = $this->option('port') ?? 3306;

        if (!$mainDb) {
            echo "❌ Debes especificar la base de datos principal con --db\n";
            exit(1);
        }
        try {
            $pdo = new \PDO("mysql:host=$host;port=$port;dbname=$mainDb", $user, $pass);
            $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

            $stmt = $pdo->query("SELECT DISTINCT idempresa FROM users");
            $empresasIds = $stmt->fetchAll(\PDO::FETCH_COLUMN);

            foreach ($empresasIds as $empresaId) {
                $tenantDb = (env('DB_TENANT_PREFIX') ?? 'tenant_') . $empresaId;

                echo "🛠 Creando base de datos $tenantDb...\n";
                $pdo->exec("CREATE DATABASE IF NOT EXISTS `$tenantDb`");

                echo "✅ Base de datos $tenantDb creada.\n";
            }

            echo "🎉 Todas las bases de datos fueron creadas exitosamente.\n";
        } catch (\PDOException $e) {
            echo "❌ Error: " . $e->getMessage() . "\n";
            exit(1);
        }
    }
}
