<?php

namespace App\Console\Commands;

use App\Models\Tenant;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class SplitImages extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'split-images
    {--path= : The path to the images directory}
    {--to= : The destination path for the split images}
    ';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $path = $this->option('path');
        $to = $this->option('to');

        if (!$path) {
            $this->error('Please provide a path to the images directory.');
            return;
        }

        $tenants = Tenant::pluck('id')->all();

        foreach ($tenants as $tenantId) {
            $this->info("Processing images for tenant: $tenantId");

            $tenantFolder = $path . '/empresa_' . $tenantId;
            if (!is_dir($tenantFolder)) {
                $this->warn("Directory does not exist: $tenantFolder");
                continue;
            }


            $files = glob($tenantFolder . '/*.{jpg,jpeg,png,gif,webp}', GLOB_BRACE);
            $totalFiles = count($files);

            if ($totalFiles === 0) {
                $this->info("No image files found for tenant: $tenantId");
                continue;
            }

            tenancy()->initialize($tenantId);

            $tenantPaths = [
                storage_path('framework'),
                storage_path('framework/cache'),
                storage_path('framework/views'),
                storage_path('app'),
                storage_path('app/public'),
                storage_path('logs'),
            ];

            foreach ($tenantPaths as $tenantPath) {
                $this->info("Creating directory: $tenantPath");
                if (!is_dir($tenantPath)) {
                    File::makeDirectory($tenantPath, 0755, true);
                }
            }
            $pathTo = storage_path('app/imagenes' . ($to ? "/$to" : ''));
            if (!is_dir($pathTo)) {
                File::makeDirectory($pathTo, 0755, true);
            }

            foreach ($files as $file) {
                $fileName = basename($file);
                $destination = $pathTo . '/' . $fileName;

                if (File::exists($destination)) {
                    $this->warn("[$tenantId] Exists: $fileName. Omitting.");
                    continue;
                }

                if (copy($file, $destination)) {
                    $this->info("[$tenantId] Copied: $fileName to " . $pathTo . "$fileName");
                } else {
                    $this->error("[$tenantId] Failed to copy: $fileName");
                }
            }
        }
    }
}
