<?php

namespace App\Enums;

enum AlertEvent: string
{
    case IsConfirmed = 'isConfirmed';
    case IsDenied = 'isDenied';
    case IsDismissed = 'isDismissed';

    /**
     * @return array<string>
     */
    public static function values(): array
    {
        return array_map(
            fn (self $event) => $event->value,
            self::cases()
        );
    }
}