<?php

namespace App\Exports\Reportes;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithTitle;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class VentasFamiliaProductoExport implements FromCollection, WithHeadings, WithMapping, WithStyles, WithTitle
{
    protected $data;
    protected $tipoVenta;
    protected $totales;

    public function __construct(array $data, string $tipoVenta, array $totales)
    {
        $this->data = collect($data);
        $this->tipoVenta = $tipoVenta;
        $this->totales = $totales;
    }

    public function collection()
    {
        return $this->data;
    }

    public function headings(): array
    {
        return [
            $this->tipoVenta === 'familia' ? 'Familia' : 'Producto',
            'Cantidad',
            'Costo',
            'Subtotal',
            'IVA',
            'Total',
            'Utilidad',
        ];
    }

    public function map($item): array
    {
        $item = (object) $item;
        return [
            $item->nombre,
            number_format($item->cantidad, 2),
            number_format($item->costo, 2),
            number_format($item->subtotal, 2),
            number_format($item->iva, 2),
            number_format($item->total, 2),
            number_format($item->utilidad, 2),
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }

    public function title(): string
    {
        return 'Ventas por ' . ($this->tipoVenta === 'familia' ? 'Familia' : 'Producto');
    }
}
