<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ClienteController extends Controller
{
    public function index(Request $request)
    {
        if(! isset($request->idsucursal))
        {
            return response()->json([
                'status' => false,
                'errors' => ['No se especificó el campo "idsucursal"']
            ], 400);
        }

        $clientes = DB::table('cat_clientes')
            ->select('idclient', 'idempresa', 'idcliente', 'clave', 'espersonafisica',
                'rfc', 'curp', 'nombrecorto', 'nombre', 'calle', 'cruzamientos',
                'noexterior', 'nointerior', 'colonia', 'referencia', 'ciudad',
                'municipio', 'estado', 'pais', 'clave_codigopostal', 'codigopostal',
                'telefono', 'email', 'http', 'contacto', 'fechaalta', 'idlistaprecio',
                'diasdecredito', 'limitecredito', 'comentarios', 'idsucursal',
                'idsucursalorigen', 'puntosacumulados', 'tarjetacliente', 'estatus',
                'imagentarjetacliente', 'imagenfotografia', 'identificacion_tarjeta',
                'identificacion_frontal', 'identificacion_posterior',
                'comprobante_domiciliario', 'nomanejadatosfiscales', 'formadepago',
                'metododepago', 'numerocuentapago', 'tipo_cliente', 'comentarios2',
                'aplicar_desctox100', 'descuento_a_aplicar', 'regimenfiscal', 'usocfdi',
                'origen_registro')
            ->where('idsucursal', $request->idsucursal);

        // Buscar por id exacto si se especifica (prioritario)
        if (isset($request->id_cliente)) {
            $clientes = $clientes->where('idcliente', $request->id_cliente);
        } else {
            // Sólo usar el parámetro 'search' para búsqueda de texto en múltiples campos
                if (isset($request->search) && strlen(trim($request->search)) > 0) {
                    $term = trim($request->search);
                    $clientes = $clientes->where(function($sub) use ($term) {
                        $sub->where('nombre', 'LIKE', '%' . $term . '%')
                            ->orWhere('nombrecorto', 'LIKE', '%' . $term . '%')
                            ->orWhere('rfc', 'LIKE', '%' . $term . '%')
                            ->orWhere('curp', 'LIKE', '%' . $term . '%')
                            ->orWhere('clave', 'LIKE', '%' . $term . '%')
                            ->orWhere('idcliente', 'LIKE', '%' . $term . '%')
                            ->orWhere('email', 'LIKE', '%' . $term . '%')
                            ->orWhere('telefono', 'LIKE', '%' . $term . '%')
                            ->orWhere('contacto', 'LIKE', '%' . $term . '%');
                    });
                }
        }

        $elementos_por_pagina = isset($request->elementos_por_pagina) ? (int)$request->elementos_por_pagina : 10;
        
        $elementos_por_pagina = max(1, min($elementos_por_pagina, 100));

        $resultados = $clientes->simplePaginate($elementos_por_pagina);

        return response()->json([
            'status' => true,
            'data' => $resultados,
            'message' => 'Lista de clientes.',
        ], 200);
    }
}
