<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Config;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class ConfigController extends Controller
{
    /**
     * Obtener configuración del tenant actual desde la base de datos central
     *
     * @return JsonResponse
     */
    public function getConfig(): JsonResponse
    {
        try {
            $user = auth('api')->user();

            // Buscar configuración en la base de datos central (modelo ya configurado con conexión mysql)
            $config = null;
            if (!empty($user) && isset($user->tenant_id)) {
                $config = Config::where('idempresa', $user->tenant_id)->first();
            }

            if (!$config) {
                return response()->json([
                    'success' => false,
                    'message' => 'Configuración no encontrada para la empresa (tenant: ' . ($user->tenant_id ?? 'N/A') . ')',
                    'data' => null
                ], 404);
            }

            return response()->json([
                'success' => true,
                'message' => 'Configuración obtenida exitosamente',
                'data' => $config
            ], 200);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error al obtener la configuración: ' . $e->getMessage(),
                'data' => null
            ], 500);
        }
    }
}
