<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\CatEmpresa;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;

class EmpresaController extends Controller
{
    /**
     * Obtener información de la empresa del tenant actual
     *
     * @return JsonResponse
     */
    public function getEmpresaActual(): JsonResponse
    {
        try {
            // En sistema tenant, obtenemos la primera empresa disponible
            // ya que cada tenant tiene su propia base de datos
            $empresa = CatEmpresa::first();

            if (!$empresa) {
                return response()->json([
                    'success' => false,
                    'message' => 'Empresa no encontrada',
                    'data' => null
                ], 404);
            }

            return response()->json([
                'success' => true,
                'message' => 'Información de la empresa obtenida exitosamente',
                'data' => $empresa
            ], 200);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error al obtener la información de la empresa: ' . $e->getMessage(),
                'data' => null
            ], 500);
        }
    }
}
