<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\PedidosIntermediosGeneral;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class PedidosIntermediosGeneralController extends Controller
{
    // private $usuarioIdEmpresa;

    public function __construct()
    {
        $this->middleware('api');
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $usuario = Auth::user();
        $IdUsuario = $usuario->id;
        $iPaginacion = isset($request->paginacion) ? $request->paginacion : 10;

        $arrPedidosGralIntermedios = DB::table('pedidos_intermedios_general_movil')
        ->where('idsucursal', $request->idsucursal)
        ->where('idvendedor', $IdUsuario)
        ->where('pedidoyaaplicado', 0) // para traer solo pedidos no aplicados
        ->paginate($iPaginacion);

        return response()->json([
            'status' => true,
            'data' => $arrPedidosGralIntermedios,
            'message' => 'Consulta exitosa de pedidos_intermedios_general_movil.',
        ], 200);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $idPedidoIntermedioGral = DB::table('pedidos_intermedios_general_movil')
            ->insertGetId([
                'idsucursal'           => $request->idsucursal,
                'idstatus'             => $request->idstatus,
                'fecha_pedido'         => $request->fecha_pedido,
                'fecha_pedido_entrega' => $request->fecha_pedido_entrega,
                'idcliente'            => $request->idcliente,
                'nombre_cliente'       => $request->nombre_cliente,
                'idvendedor'           => $request->idvendedor,
                'nombre_vendedor'      => $request->nombre_vendedor,
                'pedidoyaaplicado'     => $request->pedidoyaaplicado,
            ]);

        return response()->json([
            'status'      => true,
            'id_registro' => $idPedidoIntermedioGral,
            'message'     => 'Registro exitoso.',
        ], 200);
    }

    /**
     * Display the specified resource.
     */
    public function show(PedidosIntermediosGeneral $pedidosIntermediosGeneral)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, PedidosIntermediosGeneral $id)
    {
        DB::table('pedidos_intermedios_general_movil')
        ->where('idsucursal', $request->idsucursal)
        ->where('id', $id)
        ->update([
            'idstatus'             => $request->idstatus,
            'fecha_pedido'         => $request->fecha_pedido,
            'fecha_pedido_entrega' => $request->fecha_pedido_entrega,
            'idcliente'            => $request->idcliente,
            'nombre_cliente'       => $request->nombre_cliente,
            'idvendedor'           => $request->idvendedor,
            'nombre_vendedor'      => $request->nombre_vendedor,
            'pedidoyaaplicado'     => $request->pedidoyaaplicado,
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Actualización exitosa.',
        ], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PedidosIntermediosGeneral $pedidosIntermediosGeneral)
    {
        //
    }

    public function marcarComoAplicado(Request $request)
    {
        // En sistema tenant, no necesitamos filtrar por idempresa
        DB::table('pedidos_intermedios_general_movil')
        ->where('idsucursal', $request->idsucursal)
        ->where('id', $request->id_pedido_intermedio_gral)
        ->update([
            'pedidoyaaplicado' => 1
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Actualización exitosa.',
        ], 200);
    }
}
