<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Filesystem\Filesystem;

class EnsureTenantStorage
{
    public function __construct(private Filesystem $files) {}

    public function handle(Request $request, Closure $next)
    {
        // Solo si hay tenant inicializado y storage_path está sufijado
        if (function_exists('tenant') && tenant()) {
            $paths = [
                storage_path('framework'),
                storage_path('framework/cache'),
                storage_path('framework/views'),
                storage_path('app'),
                storage_path('app/public'),
                storage_path('logs'),
            ];

            foreach ($paths as $path) {
                if (! is_dir($path)) {
                    $this->files->makeDirectory($path, 0755, true);
                }
            }
        }

        return $next($request);
    }
}
