<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpFoundation\Response;

class InitializeTenancyByAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $tenantId = Auth::user()->tenant_id ?? null;
        
        $isCentral = $tenantId === null;

        if ($isCentral) {
            Log::info('Central tenant detected, skipping tenancy initialization.');
            return $next($request);
        }

        if(tenant('id') !== $tenantId) {
            Log::info('El tenant actual no coincide con el tenant del usuario: ' . tenant('id') . ' !== ' . $tenantId);
        }
        if (!tenancy()->initialized || tenant('id') !== $tenantId) {
            tenancy()->initialize($tenantId);
        }

        return $next($request);
    }
}
