<?php

namespace App\Http\Middleware;

use App\Models\Tenant;
use Closure;
use Exception;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Stancl\Tenancy\Tenancy;
use Tymon\JWTAuth\Facades\JWTAuth;

class InitializeTenancyFromJwt
{
    public function handle(Request $request, Closure $next): Response
    {
        try {
            $payload = JWTAuth::parseToken()->getPayload();

            $tenantId = $payload['tenant_id'] ?? null;

            if (!$tenantId) {
                return response()->json(['message' => 'No hay un tenant_id asociado con el usuario'], 400);
            }

            $tenant = Tenant::find($tenantId);
            
            if (!$tenant) {
                throw new Exception('\'tenant_id\' inválido');
            }
            
            tenancy()->initialize($tenant);

        } catch (\Throwable $e) {
            return response()->json([
                'message' => 'No se pudo cargar la tenencia, intentalo más tarde: '
            ], 401);
        }

        return $next($request);
    }
}
