<?php

namespace App\Livewire\Catalogos\Conceptos;

use App\Models\Concepto;
use Livewire\Attributes\Title;
use Livewire\Attributes\On;
use Livewire\Component;
use Illuminate\Support\Facades\DB;

#[Title('Editando Concepto de Inventario')]
class Edit extends Component
{
    public $idinventoryconcept = '';
    public $idempresa = '';
    public $idconceptoinventario = '';
    public $clave = '';
    public $conceptoinventario = '';
    public $idaccion = '';
    public $signo = '';
    public $editable = '';
    public $oldconcepto;
    public $acciones = [];
    public $alert_title = 'Concepto editado';
    public $alert_text = 'Se edito el concepto correctamente';

    protected $rules = [
        'clave' => 'required|string|max:255',
        'conceptoinventario' => 'required|string|max:255'
    ];

    public function mount(Concepto $concepto) {
        $this->oldconcepto = $concepto;
        $this->idinventoryconcept = $concepto->idinventoryconcept;
        $this->clave = $concepto->clave;
        $this->conceptoinventario = $concepto->conceptoinventario;
        $this->idaccion = $concepto->idaccion;

        $this->acciones = DB::table('cat_acciones')
            ->orderBy('idaccion')
            ->pluck('accion', 'idaccion')
            ->toArray();
    }

    public function render()
    {
        return view('livewire.catalogos.concepto.form');
    }

    public function save() {
        $this->validate();
        
        $updatedConcepto = Concepto::findOrFail($this->idinventoryconcept);
        $updatedConcepto->clave = $this->clave;
        $updatedConcepto->conceptoinventario = $this->conceptoinventario;
        $updatedConcepto->idaccion = $this->idaccion;

        if ($this->idaccion == 1 || $this->idaccion == 2) {
            $updatedConcepto->signo = 1;
        } elseif ($this->idaccion == 3) {
            $updatedConcepto->signo = -1;
        } else {
            $updatedConcepto->signo = 0;
        }

        $updatedConcepto->save();
        $this->dispatch('create-alert');

    }

    #[On('on-accept')]
    public function onAccept() {
        return redirect()->route('d-catalogos-conceptos');
    }

    public function clear() {
        $this->idinventoryconcept = $this->oldconcepto->idinventoryconcept;
        $this->clave = $this->oldconcepto->clave;
        $this->conceptoinventario = $this->oldconcepto->conceptoinventario;
        $this->idaccion = $this->oldconcepto->idaccion  ;
    }

    public function cancel() {
        return $this->dispatch('go-back');
    }
}
