<?php

namespace App\Livewire\Catalogos\Conceptos;

use App\Models\Concepto;
use Livewire\Attributes\Title;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Facades\Auth;

#[Title('Catalogo de Conceptos de Inventario')]
class Index extends Component
{
    use WithPagination;

    public $search = '';
    protected $queryString = ['search'];

    public $headerValues;
    public $rowsValues;

    public $idEmpresa;

    protected $listeners = ['delete'];


    public function updatingSearch() {
        $this->resetPage();
    }

    public function render()
    {
        $conceptos = Concepto::searchOr(['clave', 'conceptoinventario'], $this->search)
        ->paginate(10);

        return view('livewire.catalogos.concepto.index', [
            'conceptos' => $conceptos
        ]);
    }

    public function mount() {
        $this->idEmpresa = Auth::user()->idempresa;
        $this->headerValues = [
            'ID',
            'ID Empresa',
            'ID Concepto',
            'Clave',
            'Concepto',
            'ID Accion',
            'Signo',
            'Editable',
            'Acciones'
        ];
    }
    private function getRowsValues($conceptos) {
        return $conceptos->map(function($conceptos) {
            return [
                strval($conceptos->idinventoryconcept),
                strval($conceptos->idempresa),
                strval($conceptos->idconceptoinventario),
                strval($conceptos->clave),
                strval($conceptos->conceptoinventario),
                strval($conceptos->idaccion),
                strval($conceptos->signo),
                strval($conceptos->editable),
            ];
        });
    }

    public function create() {
        return redirect()->route('d-catalogos-conceptos-create');

    }

    public function edit(string $idinventoryconcept) {
        return redirect()->route('d-catalogos-conceptos-edit', ['concepto'=> $idinventoryconcept]);
    }
    
    public function confirmdelete(string $idinventoryconcept) {
        $this->dispatch('confirmar-eliminacion', ['id' => $idinventoryconcept, 'successText' => '¡El concepto se ha borrado para siempre!']);
    }

    #[On('delete')]
    public function delete($id) {
    Concepto::destroy($id);
    }
}