<?php

namespace App\Livewire\Catalogos\Familia;

use App\Models\Familia;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\Title;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithPagination;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\FamiliaExport;

#[Title('Catalogo de Familias')]
class Index extends Component
{
    use WithPagination;

    public $search = '';
    protected $queryString = ['search'];

    public $headerValues;
    public $rowsValues;

    public $idEmpresa;

    public function updatingSearch() {
        $this->resetPage();
    }

    public function render()
    {
        $familias = Familia::searchOr(['clave', 'nombrefamilia'], $this->search)
        ->paginate(10);

        return view('livewire.catalogos.familia.index', [
            'familias' => $familias
        ]);
    }

    public function mount() {
        $this->idEmpresa = Auth::user()->idempresa;
        $this->headerValues = [
            'ID',
            'Empresa ID',
            'Clave',
            'Nombre Familia',
            'Comentario',
            'Acciones'
        ];
    }

    public function create() {
        return redirect()->route('d-catalogos-familias-create');

    }

    public function edit(string $familyid) {
        return redirect()->route('d-catalogos-familias-edit', ['family'=> $familyid]);
    }

    public function confirmdelete(string $familyid) {
        $this->dispatch('confirmar-eliminacion', [
            'id'          => $familyid,
            'successText' => '¡La familia se ha borrado para siempre!',
        ]);
    }

    public function export() {
        return Excel::download(new FamiliaExport($this->idEmpresa), 'familia.xlsx');
    }

    #[On('delete')]
    public function delete($id) {
    Familia::destroy($id);
    }
}
