<?php

namespace App\Livewire\Catalogos\Marca;

use Livewire\Attributes\Title;
use Livewire\Attributes\On;
use Livewire\Component;
use App\Models\Marca;
use Illuminate\Support\Facades\Auth;

#[Title('Creando Marca')]
class Create extends Component
{
    public $clave = '';
    public $marca = '';
    public $comentarios = '';
    public $alerttitle = 'Marca creada';
    public $alerttext = 'Se creó la marca correctamente';

    protected $rules = [
        'clave' => 'required|string|max:255',
        'marca' => 'required|string|max:255',
        'comentarios' => 'nullable|string|max:500',
    ];
    
    public function render()
    {
        return view('livewire.catalogos.marca.form');
    }

    public function save() {
        $this->validate();
        $marca = Marca::create([
            'idempresa' => Auth::user()->idempresa,
            'clave' => $this->clave,
            'marca' => $this->marca,
            'comentarios' => $this->comentarios,
            'idmarca' => 0,
        ]);

        $marca->idmarca = $marca->idbrand;
        $marca->save();
        $this->dispatch('create-alert');
      
    }

    #[On('on-accept')]
    public function onAccept() {
        return redirect()->route('d-catalogos-marcas');
    }

    public function cancel() {
        return $this->dispatch('go-back');
    }
    
    public function clear() {
        $this->reset();
    }
}
