<?php

namespace App\Livewire\Catalogos\Marca;

use App\Models\Marca;
use Livewire\Attributes\Title;
use Livewire\Attributes\On;
use Livewire\Component;

#[Title('Editando Marca')]
class Edit extends Component
{
    public $idbrand;
    public $clave;
    public $marca;
    public $comentarios;
    public $oldmarca;
    public $alerttitle = 'Marca editada';
    public $alerttext = 'Se edito la marca correctamente';

    protected $rules = [
        'clave' => 'required|string|max:255',
        'marca' => 'required|string|max:255',
        'comentarios' => 'nullable|string|max:500',
    ];
    public function mount(Marca $marca) {
        $this->oldmarca = $marca;
        $this->idbrand = $marca->idbrand;
        $this->clave = $marca->clave;
        $this->marca = $marca->marca;
        $this->comentarios = $marca->comentarios;
    }

    public function render()
    {
        return view('livewire.catalogos.marca.form');
    }

    public function save() {
        $this->validate();
        
        $updatedMarca = Marca::findOrFail($this->idbrand);
        $updatedMarca->clave = $this->clave;
        $updatedMarca->marca = $this->marca;
        $updatedMarca->comentarios = $this->comentarios;

        $updatedMarca->save();
        $this->dispatch('create-alert');

    }

    #[On('on-accept')]
    public function onAccept() {
        return redirect()->route('d-catalogos-marcas');
    }

    public function clear() {
        $this->idbrand = $this->oldmarca->idbrand;
        $this->clave = $this->oldmarca->clave;
        $this->comentarios = $this->oldmarca->comentarios;
        $this->marca = $this->oldmarca->marca;
    }

    public function cancel() {
        return $this->dispatch('go-back');
    }
}
