<?php

namespace App\Livewire\Catalogos\Marca;

use App\Models\Marca;
use Livewire\Attributes\Title;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\MarcaExport;
use Mpdf\Mpdf;
#[Title('Catalogo de Marcas')]
class Index extends Component
{
    use WithPagination;

    public $search = '';
    protected $queryString = ['search'];

    public $headerValues;
    public $rowsValues;

    protected $listeners = ['delete'];


    public function updatingSearch() {
        $this->resetPage();
    }

    public function render()
    {
        $marcas = Marca::searchOr(['clave', 'marca'], $this->search)
        ->paginate(10);

        return view('livewire.catalogos.marca.index', [
            'marcas' => $marcas
        ]);
    }

    public function mount() {
        $this->headerValues = [
            'ID',
            'Clave',
            'Marca',
            'Comentario',
            'Acciones'
        ];
    }

    public function create() {
        return redirect()->route('d-catalogos-marca-create');

    }

    public function edit(string $idbrand) {
        return redirect()->route('d-catalogos-marca-edit', ['marca'=> $idbrand]);
    }
    
    public function confirmdelete(string $idbrand) {
        $this->dispatch('confirmar-eliminacion', [
            'id'          => $idbrand,
            'successText' => '¡La marca se ha borrado para siempre!',
        ]);
    }

    public function export() {
        return Excel::download(new MarcaExport($this->search), 'marcas.xlsx');
    }

public function exportPdf() {
        $marcas = Marca::searchOr(['clave', 'marca'], $this->search)
            ->get();

        $html = view('exports.marcas', ['marcas' => $marcas])->render();
        $mpdf = new Mpdf([
            'mode' => 'utf-8',
            'format' => 'A4'
        ]);

        $mpdf->WriteHTML($html);
        return response()->streamDownload(function() use ($mpdf) {
            $mpdf->Output('catalogo_marcas.pdf', 'D');
        }, 'catalogo_marcas.pdf');
    }

    #[On('delete')]
    public function delete($id) {
    Marca::destroy($id);
    }
}
