<?php

namespace App\Livewire\Catalogos\Proveedores;

use App\Models\Proveedor;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\Title;
use Livewire\Component;

#[Title('Crear Proveedor')]
class Create extends Component
{
    public $activeTab = 'general'; // Pestaña activa

    // Propiedades públicas para los campos del formulario
    public $clave, $nombrecorto, $nombrecomercial, $razonsocial, $rfc, $curp, $telefono, $fax, $email, $contacto, $limite_credito, $dias_credito;
    public $calle, $cruzamientos, $no_exterior, $no_interior, $colonia, $localidad, $municipio, $estado, $pais, $cp, $referencia, $tipo_persona = 0;

    protected $rules = [
        'clave' => 'required|string|max:255',
        'razonsocial' => 'required|string|max:255',
        'rfc' => 'required|string|max:13',
        'tipo_persona' => 'required|boolean',
        'calle' => 'required|string|max:255',
        'pais' => 'required|string|max:255',
        'cp' => 'required|string|max:10',
        'localidad' => 'required|string|max:255',
        'municipio' => 'required|string|max:255',
        'estado' => 'required|string|max:255',

        'nombrecorto' => 'nullable|string|max:255',
        'nombrecomercial' => 'nullable|string|max:255',
        'curp' => 'nullable|string|max:18',
        'telefono' => 'nullable|string|max:15',
        'fax' => 'nullable|string|max:15',
        'email' => 'nullable|email|max:255',
        'contacto' => 'nullable|string|max:255',
        'limite_credito' => 'nullable|numeric|min:0',
        'dias_credito' => 'nullable|integer|min:0',
        'cruzamientos' => 'nullable|string|max:255',
        'no_exterior' => 'nullable|string|max:50',
        'no_interior' => 'nullable|string|max:50',
        'colonia' => 'nullable|string|max:255',
        'referencia' => 'nullable|string|max:255',
    ];

    public function render()
    {
        return view('livewire.catalogos.proveedores.create');
    }

    public function cancel()
    {
        // Redirige a la ruta de proveedores
        return redirect()->route('d-catalogos-proveedores');
    }

    public function save()
    {
        $this->validate();

        $newProveedor = Proveedor::create([
            'idempresa' => Auth::user()->idempresa,
            'clave' => $this->clave,
            'espersonafisica' => $this->tipo_persona,
            'rfc' => $this->rfc,
            'curp' => $this->curp ?? '',
            'nombrecorto' => $this->nombrecorto ?? '',
            'nombrecomercial' => $this->nombrecomercial ?? '',
            'nombre' => $this->razonsocial, // Mapeo de 'razonsocial' a 'nombre'
            'calle' => $this->calle,
            'noexterior' => $this->no_exterior ?? '',
            'nointerior' => $this->no_interior ?? '',
            'cruzamientos' => $this->cruzamientos ?? '',
            'colonia' => $this->colonia ?? '',
            'codigopostal' => $this->cp,
            'ciudad' => $this->localidad,
            'municipio' => $this->municipio,
            'estado' => $this->estado,
            'pais' => $this->pais,
            'referencia' => $this->referencia ?? '',
            'telefono' => $this->telefono ?? '',
            'fax' => $this->fax ?? '',
            'email' => $this->email ?? '',
            'contacto' => $this->contacto ?? '',
            'limitecredito' => $this->limite_credito ?? 0,
            'diasdecredito' => $this->dias_credito ?? 0,
            'fechaalta' => now(),
            'origen_registro' => 'ESCRITORIO',
        ]);

        $newProveedor->save();

        $this->reset();

        return redirect()->route('d-catalogos-proveedores');
    }

    public function clear() {
        $this->reset();
    }

}
