<?php

namespace App\Livewire\Catalogos\Proveedores;

use Livewire\Attributes\Title;
use Livewire\Component;
use App\Models\Proveedor;

#[Title('Editar Proveedor')]
class Edit extends Component
{
    public $proveedorId; // ID del proveedor a editar
    public $activeTab = 'general'; // Pestaña activa

    // Propiedades públicas para los campos del formulario
    public $clave, $nombrecorto, $nombrecomercial, $razonsocial, $rfc, $curp, $telefono, $fax, $email, $contacto, $limite_credito, $dias_credito;
    public $calle, $cruzamientos, $no_exterior, $no_interior, $colonia, $localidad, $municipio, $estado, $pais, $cp, $referencia, $tipo_persona = 0;


    protected $rules = [
        'clave' => 'required|string|max:255',
        'razonsocial' => 'required|string|max:255',
        'rfc' => 'required|string|max:13',
        'tipo_persona' => 'required|boolean',
        'calle' => 'required|string|max:255',
        'pais' => 'required|string|max:255',
        'cp' => 'required|string|max:10',
        'localidad' => 'required|string|max:255',
        'municipio' => 'required|string|max:255',
        'estado' => 'required|string|max:255',

        'nombrecorto' => 'nullable|string|max:255',
        'nombrecomercial' => 'nullable|string|max:255',
        'curp' => 'nullable|string|max:18',
        'telefono' => 'nullable|string|max:15',
        'fax' => 'nullable|string|max:15',
        'email' => 'nullable|email|max:255',
        'contacto' => 'nullable|string|max:255',
        'limite_credito' => 'nullable|numeric|min:0',
        'dias_credito' => 'nullable|integer|min:0',
        'cruzamientos' => 'nullable|string|max:255',
        'no_exterior' => 'nullable|string|max:50',
        'no_interior' => 'nullable|string|max:50',
        'colonia' => 'nullable|string|max:255',
        'referencia' => 'nullable|string|max:255',
    ];

    public function mount(Proveedor $proveedor)
    {
            $this->proveedorId = $proveedor->idprovider; // ID del proveedor a editar

        // Cargar los datos del proveedor en el formulario

            $this->clave = $proveedor->clave;
            $this -> nombrecorto = $proveedor->nombrecorto;
            $this -> nombrecomercial = $proveedor->nombrecomercial;
            $this -> razonsocial = $proveedor->nombre;
            $this -> rfc = $proveedor->rfc;
            $this -> curp = $proveedor->curp;
            $this -> telefono = $proveedor->telefono;
            $this -> fax = $proveedor->fax;
            $this -> email = $proveedor->email;
            $this -> contacto = $proveedor->contacto;
            $this -> limite_credito = $proveedor->limitecredito;
            $this -> dias_credito = $proveedor->diasdecredito;
            $this -> calle = $proveedor->calle;
            $this -> cruzamientos = $proveedor->cruzamientos;
            $this -> no_exterior = $proveedor->noexterior;
            $this -> no_interior = $proveedor->nointerior;
            $this -> colonia = $proveedor->colonia;
            $this -> localidad = $proveedor->ciudad;
            $this -> municipio = $proveedor->municipio;
            $this -> estado = $proveedor->estado;
            $this -> pais = $proveedor->pais;
            $this -> cp = $proveedor->codigopostal;
            $this -> referencia = $proveedor->referencia;
            $this -> tipo_persona = $proveedor->espersonafisica;
    }

    public function save()
    {
        $this->validate();

        $proveedor = Proveedor::findOrFail($this->proveedorId);

        $updatedProveedor = $proveedor->update([
            'clave' => $this->clave,
            'espersonafisica' => $this->tipo_persona,
            'rfc' => $this->rfc,
            'curp' => $this->curp ?? '',
            'nombrecorto' => $this->nombrecorto ?? '',
            'nombrecomercial' => $this->nombrecomercial ?? '',
            'nombre' => $this->razonsocial, // Mapeo de 'razonsocial' a 'nombre'
            'calle' => $this->calle,
            'noexterior' => $this->no_exterior ?? '',
            'nointerior' => $this->no_interior ?? '',
            'cruzamientos' => $this->cruzamientos ?? '',
            'colonia' => $this->colonia ?? '',
            'codigopostal' => $this->cp,
            'ciudad' => $this->localidad,
            'municipio' => $this->municipio,
            'estado' => $this->estado,
            'pais' => $this->pais,
            'referencia' => $this->referencia ?? '',
            'telefono' => $this->telefono ?? '',
            'fax' => $this->fax ?? '',
            'email' => $this->email ?? '',
            'contacto' => $this->contacto ?? '',
            'limitecredito' => $this->limite_credito ?? 0,
            'diasdecredito' => $this->dias_credito ?? 0,
        ]);

        session()->flash('message', 'Proveedor actualizado correctamente.');
        return redirect()->route('d-catalogos-proveedores');
    }

    public function render()
    {
        // Reutilizar la vista create.blade.php
        return view('livewire.catalogos.proveedores.create');
    }
}
