<?php

namespace App\Livewire\Catalogos\Usuario;

use App\Models\Usuario;
use Livewire\Attributes\Title;
use Livewire\Attributes\On;
use Livewire\Component;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Models\Perfil;
use App\Models\Sucursal;
use App\Models\Permiso;

#[Title('Editando Usuario')]
class Edit extends Component
{
    public $activeTab = 'general';
    public $idempresa = '';
    public $idusuario = '';
    public $nombre = '';
    public $usuario = '';
    public $pasword = '';
    public $confirmpasword = '';
    public $perfil = '';
    public $perfiles = [];
    public $sucursal = '';
    public $sucursales = [];
    public $permisos = [];
    public $alert_title = 'Usuario editado';
    public $alert_text = 'Se edito el usuario correctamente';

    protected $rules = [
        'nombre' => 'required|string|max:255',
        'usuario' => 'required|string|max:255',
        'pasword' => 'required|string|max:255',
        'confirmpasword' => 'required|string|same:pasword',
        'perfil'              => 'required|integer|exists:perfiles,idperfil',
        'sucursal'            => 'required|integer|exists:cat_sucursales,idsucursal',
    ];

    public function mount($user)
    {
        $usuario = Usuario::findOrFail($user);
        $this->idusuario = $usuario->iduser;
        $this->idempresa = $usuario->idempresa;
        $this->nombre = $usuario->nombre;
        $this->usuario = $usuario->usuario;
        $this->pasword = $usuario->pasword;
        $this->confirmpasword = $usuario->pasword;
        $this->perfil = $usuario->idperfil;
        $this->sucursal = $usuario->idsucursal;

        $menus = DB::table('menus')->get();
        $menuopciones = DB::table('menuopciones')->get()->groupBy('idmenu');
        $permisosUsuario = Permiso::where('idusuario', $this->idusuario)->get()->groupBy('idmenu');
        foreach ($menus as $menu) {
            $opciones = [];
            if (isset($menuopciones[$menu->idmenu])) {
                foreach ($menuopciones[$menu->idmenu] as $opcion) {
                    $permitir = false;
                    if (isset($permisosUsuario[$menu->idmenu])) {
                        foreach ($permisosUsuario[$menu->idmenu] as $permiso) {
                            if ($permiso->idmenuopcion == $opcion->idmenuopcion && $permiso->permitir) {
                                $permitir = true;
                                break;
                            }
                        }
                    }
                    $opciones[$opcion->idmenuopcion] = [
                        'idmenuopcion' => $opcion->idmenuopcion,
                        'nombre' => $opcion->descripcion,
                        'permitir' => $permitir,
                    ];
                }
            }
            $this->permisos[$menu->idmenu] = $opciones;
        }

        $this->perfiles = Perfil::orderBy('nivel_acceso')
            ->pluck('nombre', 'idperfil')
            ->toArray();
        $this->sucursales = Sucursal::where('idempresa', Auth::user()->idempresa)
            ->orderBy('razon_social')
            ->pluck('razon_social', 'idsucursal')
            ->toArray();

    }


    public function render()
    {
        return view('livewire.catalogos.usuario.form', [
            'perfiles' => $this->perfiles,
            'sucursales' => $this->sucursales,
            'permisos' => $this->permisos,
        ]);
    }

    public function save() {
        $this->validate();
        
        DB::transaction(function () {
            $usuario = Usuario::findOrFail($this->idusuario);
            $usuario->update([
                'nombre'             => $this->nombre,
                'usuario'            => $this->usuario,
                'pasword'            => $this->pasword,
                'idperfil'           => $this->perfil,
                'idsucursal'         => $this->sucursal,
                'nopermitirborrarreg' => in_array($this->perfil, [1001, 2001]) ? 0 : 1,
            ]);

                Permiso::where('idusuario', $usuario->iduser)->delete();
            
                foreach ($this->permisos as $idmenu => $options) {
                foreach ($options as $option) {
                    Permiso::create([
                        'idempresa'      => Auth::user()->idempresa,
                        'idsucursal'     => $this->sucursal,
                        'iddesk'         => 1,
                        'idusuario'      => $usuario->iduser,
                        'idperfil'       => $this->perfil,
                        'idmenu'         => $idmenu,
                        'idmenuopcion'   => $option['idmenuopcion'],
                        'permitir'       => $option['permitir'] ? 1 : 0,
                        'origen_registro' => 1,
                    ]);
                }
            }
        });
        $this->dispatch('create-alert');

    }

    #[On('on-accept')]
    public function onAccept() {
        return redirect()->route('d-catalogos-usuarios');
    }

    public function clear() {
    }

    public function cancel() {
        return $this->dispatch('go-back');
    }
}
