<?php

namespace App\Livewire\Catalogos\Usuario;

use App\Models\Permiso;
use Livewire\Component;
use App\Models\Usuario;
use Livewire\Attributes\Title;
use Livewire\Attributes\On;
use Livewire\WithPagination;
use Illuminate\Support\Facades\Auth;

#[Title('Catalogo de Usuarios')]
class Index extends Component
{
    use WithPagination;

    public $search = '';
    protected $queryString = ['search'];

    public $headerValues;
    public $rowsValues;
    
    public $deletedtext = 'Usuario eliminado';

    protected $listeners = ['delete'];


    public function updatingSearch() {
        $this->resetPage();
    }

    public function render()
    {
        $usuarios = Usuario::searchOr(['nombre', 'usuario'], $this->search)
        ->paginate(10);
        return view('livewire.catalogos.usuario.index', [
            'usuarios' => $usuarios
        ]);
    }

    public function mount() {
        $this->headerValues = [
            'ID User',
            'ID Sucursal',
            'ID Usuario',
            'Usuario',
            'Nombre',
            'Acciones'
        ];
    }

    public function create() {
        return redirect()->route('d-catalogos-usuarios-create');

    }

    public function edit(string $iduser) {
        return redirect()->route('d-catalogos-usuarios-edit', ['user'=> $iduser]);
    }
    
    public function confirmdelete(string $iduser) {
        $this->dispatch('confirmar-eliminacion', ['id' => $iduser, 'successText' => '¡El usuario se ha borrado para siempre!']);
    }

    #[On('delete')]
    public function delete($id) {
    Usuario::destroy($id);
    Permiso::where('idusuario', $id)->delete();
    }
}
