<?php

namespace App\Livewire\Reportes\CortesCaja;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\Title;
use Livewire\Component;

#[Title('Detalle de Corte de Caja')]
class Detalle extends Component
{
    public $idTurno;
    public $idSucursal;
    public $idEmpresa;
    
    public $corte;
    public $corteDetalle = [];
    public $sucursal;
    
    public $ingresosPorTipoPago = [];
    public $ingresos = [];
    public $egresos = [];
    
    public $totalIngresos = 0;
    public $totalEgresos = 0;
    public $totalPorTipoPago = 0;
    public $diferencia = 0;

    public function mount($idturno, $idsucursal)
    {
        $this->idTurno = $idturno;
        $this->idSucursal = $idsucursal;
        $this->idEmpresa = Auth::user()->tenant_id;
        
        $this->cargarDatos();
    }

    public function cargarDatos()
    {
        // Cargar corte general
        $this->corte = DB::table('cortes_turnos as c')
            ->select(
                'cc.*',
                'c.*',
                'u.nombre as usuario',
                'j.nombre_caja'
            )
            ->join('cat_usuarios as u', function ($join) {
                $join->on('u.idusuario', '=', 'c.idusuario')
                    ->on('u.idsucursal', '=', 'c.idsucursal');
            })
            ->join('cajas as j', function ($join) {
                $join->on('j.idcaja', '=', 'c.idcaja_apertura')
                    ->on('j.idsucursal', '=', 'c.idsucursal');
            })
            ->join('cortesdecaja as cc', function ($join) {
                $join->on('cc.idturno', '=', 'c.idturno')
                    ->on('cc.idsucursal', '=', 'c.idsucursal');
            })
            ->where('c.idturno', $this->idTurno)
            ->where('c.idsucursal', $this->idSucursal)
            ->first();

        // Cargar detalles del corte
        $this->corteDetalle = DB::table('cortes_turnos_detalle')
            ->where('idsucursal', $this->idSucursal)
            ->where('idturno_desk', $this->idTurno)
            ->orderBy('tipo')
            ->get();

        // Cargar información de la sucursal
        $this->sucursal = DB::table('cat_sucursales')
            ->where('idsucursal', $this->idSucursal)
            ->first();

        $this->procesarDetalles();
    }

    private function procesarDetalles()
    {
        $this->totalIngresos = 0;
        $this->totalEgresos = 0;
        $this->totalPorTipoPago = 0;

        foreach ($this->corteDetalle as $detalle) {
            switch ($detalle->tipo) {
                case 1: // Ingresos por tipo de pago
                    $this->ingresosPorTipoPago[] = $detalle;
                    $this->totalPorTipoPago += $detalle->importe;
                    break;
                case 2: // Ingresos
                    $this->ingresos[] = $detalle;
                    $this->totalIngresos += $detalle->importe;
                    break;
                case 3: // Egresos
                    $this->egresos[] = $detalle;
                    $this->totalEgresos += $detalle->importe;
                    break;
            }
        }

        $totalCorte = $this->corte->importetotalbilletes + 
                     $this->corte->importetotalmonedas + 
                     $this->corte->importetarjetasdebito +
                     $this->corte->importetarjetascredito +
                     ($this->corte->transferencia_electronica ?? 0) +
                     ($this->corte->vales_electronicos ?? 0) +
                     ($this->corte->cheques ?? 0);

        $ingresosFinales = $this->totalIngresos - $this->totalEgresos;
        
        $this->diferencia = $totalCorte - $ingresosFinales;
    }

    public function render()
    {
        return view('livewire.reportes.cortes-caja.detalle');
    }

    public function volver()
    {
        return redirect()->route('d-reportes-cortes-caja');
    }

    public function descargarPDF()
    {
        // TODO: Implementar generación de PDF
        $this->dispatch('alert', [
            'icon' => 'info',
            'title' => 'Funcionalidad en desarrollo',
            'text' => 'La exportación a PDF estará disponible próximamente.'
        ]);
    }

    public function descargarExcel()
    {
        // TODO: Implementar generación de Excel
        $this->dispatch('alert', [
            'icon' => 'info',
            'title' => 'Funcionalidad en desarrollo',
            'text' => 'La exportación a Excel estará disponible próximamente.'
        ]);
    }
}
