<?php

namespace App\Livewire\Reportes\CostoUtilidad;

use Livewire\Attributes\Title;
use Livewire\Component;
use App\Models\Sucursal;
use Illuminate\Support\Facades\DB;

#[Title('Costo-Utilidad')]
class Index extends Component
{
    public $fechainicio;
    public $fechafinal;
    public $sucursal = '';
    public $filas = 10;

    public function mount()
    {
        $fechaInfo = DB::connection('tenant')->table('ventasgeneral')
            ->selectRaw('MIN(fechaventa) as primera, MAX(fechaventa) as ultima')
            ->first();

        if ($fechaInfo && $fechaInfo->ultima) {
            $ultimaFecha = \Carbon\Carbon::parse($fechaInfo->ultima);
            $this->fechainicio = $ultimaFecha->startOfMonth()->format('Y-m-d');
            $this->fechafinal   = $ultimaFecha->endOfMonth()->format('Y-m-d');
        } else {
            $this->fechainicio = now()->startOfMonth()->format('Y-m-d');
            $this->fechafinal  = now()->endOfMonth()->format('Y-m-d');
        }
    }

    public function render()
    {
        $queryVentas = DB::connection('tenant')->table('ventasgeneral as v')
            ->join('cat_sucursales as s', 's.idbranchoffice', '=', 'v.idsucursal')
            ->select(
                'v.folio',
                'v.fechaventa',
                DB::raw("DATE_FORMAT(v.fechahora, '%h:%i:%s %p') as horaventa"),
                'v.subtotal as costo_total',
                'v.total as venta_total',
                DB::raw('(v.total - v.subtotal) as utilidad_total'),
                's.razon_social as sucursal'
            );

        if ($this->fechainicio && $this->fechafinal) {
            $queryVentas->whereBetween('v.fechaventa', [$this->fechainicio, $this->fechafinal]);
        }

        if ($this->sucursal) {
            $queryVentas->where('v.idsucursal', $this->sucursal);
        }

        $queryVentas->where('v.idstatus', 1);

        $ventas = $queryVentas
            ->orderBy('v.fechaventa', 'desc')
            ->orderBy('v.fechahora', 'desc')
            ->limit($this->filas)
            ->get();

        $queryTotales = DB::connection('tenant')->table('ventasgeneral as v')
            ->where('v.idstatus', 1);

        if ($this->fechainicio && $this->fechafinal) {
            $queryTotales->whereBetween('v.fechaventa', [$this->fechainicio, $this->fechafinal]);
        }

        if ($this->sucursal) {
            $queryTotales->where('v.idsucursal', $this->sucursal);
        }

        $totales = $queryTotales->selectRaw('
            SUM(v.total) as venta_total,
            SUM(v.subtotal) as costo_total,
            SUM(v.total - v.subtotal) as utilidad_total
        ')->first();

        $sucursales = Sucursal::where('activo', 1)->get();

        return view('livewire.reportes.costo_utilidad.index', [
            'ventas' => $ventas,
            'ventaTotal' => $totales->venta_total ?? 0,
            'costoTotal' => $totales->costo_total ?? 0,
            'utilidadTotal' => $totales->utilidad_total ?? 0,
            'sucursales' => $sucursales,
        ]);
    }
}
