<?php

namespace App\Livewire\Ventas\Cotizaciones;

use App\Models\Cliente;
use App\Models\Producto;

class CotizacionesDataHandler
{
    public static function obtenerClientes($idempresa, $busqueda = '', $mostrarTabla = false)
    {
        if (!$mostrarTabla) {
            return collect([]);
        }

        $query = Cliente::where('idempresa', $idempresa);

        // Si hay búsqueda, filtrar por ella
        if (!empty($busqueda)) {
            $query->where(function ($subQuery) use ($busqueda) {
                $subQuery->where('nombre', 'like', '%' . $busqueda . '%')
                         ->orWhere('rfc', 'like', '%' . $busqueda . '%')
                         ->orWhere('clave', 'like', '%' . $busqueda . '%');
            });
        }

        // Limitar resultados para mejor rendimiento
        return $query->orderBy('nombre')->limit(50)->get();
    }

    public static function obtenerProductos($idempresa, $busqueda = '', $mostrarTabla = false)
    {
        if (!$mostrarTabla) {
            return collect([]);
        }

        $query = Producto::where('idempresa', $idempresa);

        // Si hay búsqueda, filtrar por ella
        if (!empty($busqueda)) {
            $query->where(function ($subQuery) use ($busqueda) {
                $subQuery->where('clave', 'like', '%' . $busqueda . '%')
                         ->orWhere('descripcion', 'like', '%' . $busqueda . '%')
                         ->orWhere('nombrecorto', 'like', '%' . $busqueda . '%');
            });
        }

        // Limitar resultados para mejor rendimiento
        return $query->orderBy('clave')->limit(50)->get();
    }

    public static function procesarSeleccionCliente($cliente)
    {
        return [
            'idclient' => $cliente['idclient'],
            'clientesearch' => $cliente['nombre'],
            'clientenombre' => $cliente['nombre'],
            'clienterfc' => $cliente['rfc'],
            'clientedireccion' => CotizacionesBaseLogic::construirDireccionCliente($cliente),
        ];
    }

    public static function procesarSeleccionProducto($producto)
    {
        return [
            'productoid' => $producto['idproduct'],
            'productosearch' => $producto['clave'] . ' - ' . $producto['descripcion'],
            'precioventaantesiva' => $producto['precioventaantesiva'],
            'precioventaconiva' => $producto['precioventaconiva'],
            'descripcion' => $producto['descripcion'],
            'claveproductoservicio' => $producto['clave_prodserv'] ?? '',
            'descripcionclaveproductoservicio' => $producto['prodserv'] ?? '',
            'claveunidadmedida' => $producto['clave_unidadmedida'] ?? '',
            'descripcionunidadmedida' => $producto['unidadmedida'] ?? '',
        ];
    }

    public static function actualizarFormularioCliente($cliente)
    {
        return [
            'nombre' => $cliente['nombre'],
            'telefono' => $cliente['telefono'] ?? '',
            'clave' => $cliente['clave'],
            'rfc' => $cliente['rfc'],
            'colonia' => $cliente['colonia'] ?? '',
        ];
    }
}
