<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MovInvExistencia extends Model
{
    use HasFactory;

    protected $table = 'mov_inv_existencias';
    protected $primaryKey = 'idmovinvexistencia';
    public $timestamps = false;
    
    protected $fillable = [
        'idsucursal',
        'idinventario',
        'idproducto',
        'idalmacen',
        'existencia',
        'contados',
        'idsucursalorigen',
        'origen_registro',
        'descargado',
        'existencia_en_presentaciones',
        'existencia_proporcional'
    ];

    protected $casts = [
        'existencia' => 'decimal:6',
        'contados' => 'integer',
        'idsucursalorigen' => 'integer',
        'descargado' => 'boolean',
        'existencia_en_presentaciones' => 'decimal:6',
        'existencia_proporcional' => 'decimal:6'
    ];
}
