<?php

namespace App\Providers;

use App\Livewire\Actions\LivewireAlert;
use App\Repositories\Inventarios\InventariosRepository;
use App\Repositories\Inventarios\InventariosRepositoryInterface;
use App\Repositories\Product\ProductoRepositoryMock;
use App\Repositories\Product\ProductRepository;
use App\Repositories\Product\ProductRepositoryInterface;
use App\Repositories\PuntoDeVenta\PuntoDeVentaInterface;
use App\Repositories\PuntoDeVenta\PuntoDeVentaRepository;
use Illuminate\Database\Query\Builder;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void{
        app()->bind(ProductRepositoryInterface::class, ProductRepository::class);
        app()->bind(PuntoDeVentaInterface::class, PuntoDeVentaRepository::class);
        $this->app->bind(InventariosRepositoryInterface::class, InventariosRepository::class);
    }


    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Builder::macro('search', function (string $column, string $searchText) {
            return $this->where($column, 'like', '%' . $searchText . '%');
        });

        Builder::macro('searchOr', function (array $columns, string $searchText) {
            $arraySize = count($columns);
            if ($arraySize == 0) {
                return $this;
            }
            return $this->where(function ($query) use ($columns, $searchText, $arraySize) {
                $query->where($columns[0], 'like', '%' . $searchText . '%');

                for ($i = 1; $i < $arraySize; $i++) {
                    $query->orWhere($columns[$i], 'like', '%' . $searchText . '%');
                }
            });
        });
    }
}
