<?php

namespace App\Repositories\Product;

use App\Models\Producto;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\LengthAwarePaginator;

interface ProductRepositoryInterface {
    
        
    /**
     * all
     *
     * @param  mixed $with
     * @return Collection<int, Producto>
     */
    public function all(array $with = []): Collection;
    
    /**
     * getProductById
     *
     * @param  mixed $id
     * @return Producto
     */
    public function find(int $id, array $with = []): ?Producto;
    
    /**
     * search
     *
     * @param  mixed $filters
     * @param  mixed $with
     * @param  mixed $perPage
     * @return LengthAwarePaginator
     */
    public function search(array $filters = [], array $with = [], int $perPage = 15): LengthAwarePaginator;
    
    /**
     * create
     *
     * @param  mixed $data
     * @return Producto
     */
    public function create(array $data): Producto;
    
    /**
     * update
     *
     * @param  mixed $id
     * @param  mixed $data
     * @return bool
     */
    public function update(int $id, array $data): bool;
    
    /**
     * delete
     *
     * @param  mixed $id
     * @return bool
     */
    public function delete(int $id): bool;
}
