<?php

use App\Http\Middleware\InitializeTenancyByAuth;
use App\Http\Middleware\InitializeTenancyFromJwt;
use App\Http\Middleware\JwtMiddleware;
use Illuminate\Auth\Middleware\Authenticate;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Support\Facades\Route;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        api: __DIR__ . '/../routes/api.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
        then: function () {
            Route::middleware('web')
                ->group(base_path('routes/web.php'));
            
            Route::middleware(['web'])
                ->group(base_path('routes/tenant.php'));
        }
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'jwt' => JwtMiddleware::class,
            'tenancy.jwt' => InitializeTenancyFromJwt::class
        ]);
        $middleware->group('universal', []);
        $middleware->priority([
            Authenticate::class,
            InitializeTenancyByAuth::class, // o InitializeTenancyByPath::class
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {})->create();
