<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Marca>
 */
class MarcaFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'idmarca' => $this->faker->numberBetween(100, 99999),
            'clave' => $this->faker->word() . '_' . microtime(true),
            'marca' => $this->faker->company(),
            'comentarios' => $this->faker->sentence(),
        ];
    }
}
