<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_clientes', function (Blueprint $table) {
            $table->id('idclient');
            $table->bigInteger('idcliente');
            $table->string('clave', 30);
            $table->smallInteger('espersonafisica');
            $table->string('rfc', 20);
            $table->string('curp', 20);
            $table->string('nombrecorto', 30);
            $table->string('nombre', 180);
            $table->string('calle', 100);
            $table->string('cruzamientos', 100);
            $table->string('noexterior', 100);
            $table->string('nointerior', 50);
            $table->string('colonia', 100);
            $table->string('referencia', 254);
            $table->string('ciudad', 50);
            $table->string('municipio', 50);
            $table->string('estado', 50);
            $table->string('pais', 50);
            $table->string('clave_codigopostal', 10)->nullable();
            $table->string('codigopostal', 30);
            $table->string('telefono', 50);
            $table->string('email', 300);
            $table->string('http', 80);
            $table->string('contacto', 80);
            $table->date('fechaalta')->nullable();
            $table->bigInteger('idlistaprecio');
            $table->smallInteger('diasdecredito');
            $table->decimal('limitecredito', 18, 6);
            $table->string('comentarios', 180);
            $table->integer('idsucursal');
            $table->integer('idsucursalorigen');
            $table->integer('puntosacumulados');
            $table->string('tarjetacliente', 30);
            $table->smallInteger('estatus');
            $table->binary('imagentarjetacliente')->nullable();
            $table->binary('imagenfotografia')->nullable();
            $table->string('identificacion_tarjeta', 50);
            $table->binary('identificacion_frontal')->nullable();
            $table->binary('identificacion_posterior')->nullable();
            $table->binary('comprobante_domiciliario')->nullable();
            $table->smallInteger('nomanejadatosfiscales');
            $table->string('formadepago', 60)->nullable();
            $table->string('metododepago', 60);
            $table->string('numerocuentapago', 50);
            $table->string('tipo_cliente', 50)->nullable();
            $table->binary('comentarios2')->nullable();
            $table->smallInteger('aplicar_desctox100')->nullable();
            $table->decimal('descuento_a_aplicar', 18, 6)->nullable();
            $table->string('regimenfiscal', 130)->nullable();
            $table->string('usocfdi', 130)->nullable();
            $table->string('origen_registro', 15)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_clientes');
    }
};
