<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_conceptosinventarios', function (Blueprint $table) {
            $table->id('idinventoryconcept');
            $table->bigInteger('idconceptoinventario');
            $table->string('clave', 20);
            $table->string('conceptoinventario', 80);
            $table->integer('idaccion');
            $table->tinyInteger('signo');
            $table->smallInteger('editable')->nullable();
            $table->string('origen_registro', 15)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_conceptosinventarios');
    }
};
