<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_insumos', function (Blueprint $table) {
            $table->id('idinput');
            $table->bigInteger('idinsumo');
            $table->bigInteger('idimpuesto');
            $table->bigInteger('idfamilia');
            $table->bigInteger('idsubfamilia');
            $table->bigInteger('idunidadmedida');
            $table->string('descripcion', 254);
            $table->string('codigodebarras', 30)->default('-1');
            $table->smallInteger('manejainventario');
            $table->smallInteger('manejacaducidad');
            $table->smallInteger('insumoactivo');
            $table->date('fechaalta')->nullable();
            $table->date('fechaultimacompra')->nullable();
            $table->decimal('precioultimacomprasiniva', 18, 6);
            $table->decimal('precioucompraconiva', 18, 6);
            $table->decimal('costopromediosiniva', 18, 6);
            $table->decimal('stockminimo', 18, 6);
            $table->binary('imagencodigobarras')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_insumos');
    }
};
