<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_monedas', function (Blueprint $table) {
            $table->bigInteger('idmoneda')->primary();
            $table->string('clave_moneda', 10);
            $table->string('descripcion', 80);
            $table->smallInteger('decimales');
            $table->decimal('porcentaje_variacion', 18, 6)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_monedas');
    }
};
