<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_prodserv', function (Blueprint $table) {
            $table->bigInteger('idprodserv')->primary();
            $table->string('clave_prodserv', 10)->nullable();
            $table->string('descripcion', 150);
            $table->date('fecha_inicio_vigencia')->nullable();
            $table->date('fecha_fin_vigencia')->nullable();
            $table->smallInteger('incluir_iva_trasladado')->nullable();
            $table->smallInteger('incluir_ieps_trasladado')->nullable();
            $table->string('complemento_a_incluir', 150)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_prodserv');
    }
};
