<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_tasa_o_cuota', function (Blueprint $table) {
            $table->bigInteger('idtasaimpuesto')->primary();
            $table->string('tipo_rango', 10);
            $table->decimal('valor_minimo', 18, 6)->nullable();
            $table->decimal('valor_maximo', 18, 6);
            $table->string('impuesto', 20);
            $table->string('factor', 20);
            $table->smallInteger('traslado');
            $table->smallInteger('retencion');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_tasa_o_cuota');
    }
};
