<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_tiposdepago', function (Blueprint $table) {
            $table->id('idpaymenttype');
            $table->bigInteger('idsucursal');
            $table->bigInteger('idtipopago');
            $table->string('clave', 20);
            $table->string('nombrecorto', 20);
            $table->string('nombre', 60);
            $table->smallInteger('estarjetadecredito');
            $table->smallInteger('escredito');
            $table->smallInteger('plazocredito');
            $table->smallInteger('darcambio');
            $table->smallInteger('visible');
            $table->decimal('comision', 18, 6);
            $table->decimal('tipodecambio', 18, 6);
            $table->smallInteger('requierereferencia');
            $table->smallInteger('prioridadvisualizacion');
            $table->binary('imagen')->nullable();
            $table->date('fechaalta')->nullable();
            $table->string('origen_registro', 15)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_tiposdepago');
    }
};
