<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_unidades', function (Blueprint $table) {
            $table->bigInteger('idunidad')->primary();
            $table->string('clave_unidad', 10)->nullable();
            $table->string('nombre', 150);
            $table->string('descripcion', 254)->nullable();
            $table->date('fecha_inicio_vigencia')->nullable();
            $table->date('fecha_fin_vigencia')->nullable();
            $table->string('simbolo', 30)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_unidades');
    }
};
