<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cfdi_detalle', function (Blueprint $table) {
            $table->id('idcfdidetalle');
            $table->bigInteger('idsucursal');
            $table->bigInteger('idcfdi_detalle');
            $table->bigInteger('idcfdi_general');
            $table->bigInteger('idproducto');
            $table->string('clave_prodserv', 10);
            $table->string('prodserv', 150);
            $table->string('noidentificacion', 100);
            $table->decimal('cantidad', 18, 6);
            $table->string('clave_unidad', 10);
            $table->string('unidadmedida', 150);
            $table->string('descripcion', 1000);
            $table->decimal('valorunitario', 18, 6);
            $table->decimal('importe', 18, 6);
            $table->decimal('descuentox100', 18, 6);
            $table->decimal('descuento', 18, 6);
            $table->string('clave_impuesto', 10);
            $table->string('impuesto', 80);
            $table->string('clave_tipofactor', 10);
            $table->string('tasa_factor', 10)->nullable();
            $table->string('tasa_impuesto', 20)->nullable();
            $table->string('tasa_tipo_rango', 10)->nullable();
            $table->decimal('tasa_valor_maximo', 18, 6)->nullable();
            $table->smallInteger('tasa_traslado')->nullable();
            $table->smallInteger('tasa_retencion')->nullable();
            $table->decimal('importe_impuesto', 18, 6);
            $table->decimal('subtotal', 18, 6);
            $table->decimal('iva', 18, 6);
            $table->decimal('total', 18, 6);
            $table->bigInteger('idturno')->nullable();
            $table->bigInteger('web_idempresa')->nullable();
            $table->bigInteger('web_idsucursal')->nullable();
            $table->smallInteger('enviado_web')->nullable();
            $table->bigInteger('idalmacen');
            $table->decimal('costopromedio', 18, 6)->nullable();
            $table->string('info_cuentapredial', 50)->nullable();
            $table->string('clave_producto', 30)->nullable();
            $table->string('origen_registro', 15)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cfdi_detalle');
    }
};
