<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('comprasdetalle', function (Blueprint $table) {
            $table->id('idweb');
            $table->bigInteger('idsucursal');
            $table->bigInteger('iddesk')->nullable();
            $table->bigInteger('idcomprageneral')->nullable();
            $table->bigInteger('idproducto');
            $table->decimal('cantidad', 18, 6);
            $table->date('fechacaducidad')->nullable();
            $table->decimal('precio', 18, 6);
            $table->decimal('importe', 18, 6);
            $table->decimal('descuentox100', 18, 6);
            $table->decimal('descuento', 18, 6);
            $table->decimal('subtotal', 18, 6);
            $table->decimal('iva', 18, 6);
            $table->decimal('total', 18, 6);
            $table->timestamp('fechahoradocumento')->nullable();
            $table->bigInteger('idfamilia')->nullable();
            $table->string('clave_familia', 20)->nullable();
            $table->bigInteger('idmarca')->nullable();
            $table->string('clave_marca', 20)->nullable();
            $table->bigInteger('idusuario')->nullable();
            $table->string('usuario', 50)->nullable();
            $table->bigInteger('idturno')->nullable();
            $table->bigInteger('idturno_desk')->nullable();
            $table->bigInteger('idalmacen')->nullable();
            $table->string('almacen', 20)->nullable();
            $table->string('clave', 30)->nullable();
            $table->string('descripcion', 254)->nullable();
            $table->string('traslado_iva_tipo_factor', 20)->nullable();
            $table->decimal('traslado_iva_tasa_cuota', 18, 6)->nullable();
            $table->decimal('traslado_iva_importe', 18, 6)->nullable();
            $table->string('traslado_ieps_tipo_factor', 20)->nullable();
            $table->decimal('traslado_ieps_tasa_cuota', 18, 6)->nullable();
            $table->decimal('traslado_ieps_importe', 18, 6)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('comprasdetalle');
    }
};
