<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('comprasgeneral', function (Blueprint $table) {
            $table->id('idweb');
            $table->bigInteger('iddesk');
            $table->bigInteger('idsucursal')->nullable();
            $table->smallInteger('origen_registro')->nullable();
            $table->tinyInteger('idstatus');
            $table->date('fechacomprageneral')->nullable();
            $table->bigInteger('idproveedor');
            $table->integer('idtipodocumento');
            $table->string('numerodocumento', 20);
            $table->date('fechadocumento')->nullable();
            $table->string('horadocumento', 8);
            $table->smallInteger('pagado');
            $table->bigInteger('idtipopago');
            $table->string('referencia', 80);
            $table->bigInteger('idalmacen');
            $table->bigInteger('idusuario');
            $table->decimal('totaldocumentocompra', 18, 6);
            $table->decimal('descuentox100', 18, 6);
            $table->decimal('descuento', 18, 6);
            $table->decimal('subtotal', 18, 6);
            $table->decimal('iva', 18, 6);
            $table->decimal('totalcompra', 18, 6);
            $table->string('comentarios', 400)->nullable();
            $table->string('numeromovimiento', 30);
            $table->decimal('abono', 18, 6);
            $table->decimal('saldo', 18, 6);
            $table->bigInteger('folio');
            $table->bigInteger('idturno')->nullable();
            $table->bigInteger('idturno_desk')->nullable();
            $table->timestamp('fechahora_registro')->nullable();
            $table->string('usuario', 50)->nullable();
            $table->string('from_host', 50)->nullable();
            $table->string('origen_movimiento', 50)->nullable();
            $table->decimal('traslado_ieps_importe', 18, 6)->nullable();
            $table->decimal('traslado_iva_importe', 18, 6)->nullable();
            $table->decimal('retencion_iva_importe', 18, 6)->nullable();
            $table->decimal('retencion_isr_importe', 18, 6)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('comprasgeneral');
    }
};
