<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cortesdecaja', function (Blueprint $table) {
            $table->id('idcutbox');
            $table->bigInteger('idsucursal');
            $table->bigInteger('idcortedecaja');
            $table->date('fechacortedecaja')->nullable();
            $table->bigInteger('idusuario');
            $table->string('turnocorte', 50);
            $table->string('comentarios', 240);
            $table->integer('totalbilletes1000');
            $table->integer('totalbilletes500');
            $table->integer('totalbilletes200');
            $table->integer('totalbilletes100');
            $table->integer('totalbilletes50');
            $table->integer('totalbilletes20');
            $table->integer('totalmonedas20');
            $table->integer('totalmonedas10');
            $table->integer('totalmonedas5');
            $table->integer('totalmonedas2');
            $table->integer('totalmonedas1');
            $table->integer('totalmonedas50c');
            $table->integer('totalmonedas20c');
            $table->integer('totalmonedas10c');
            $table->decimal('cantidadinicialcaja', 18, 6);
            $table->decimal('importetotalbilletes', 18, 6);
            $table->decimal('importetotalmonedas', 18, 6);
            $table->decimal('importetotalefectivo', 18, 6);
            $table->decimal('totalturnocorte', 18, 6);
            $table->decimal('importebilletes1000', 18, 6);
            $table->decimal('importebilletes500', 18, 6);
            $table->decimal('importebilletes200', 18, 6);
            $table->decimal('importebilletes100', 18, 6);
            $table->decimal('importebilletes50', 18, 6);
            $table->decimal('importebilletes20', 18, 6);
            $table->decimal('importemonedas20', 18, 6);
            $table->decimal('importemonedas10', 18, 6);
            $table->decimal('importemonedas5', 18, 6);
            $table->decimal('importemonedas2', 18, 6);
            $table->decimal('importemonedas1', 18, 6);
            $table->decimal('importemonedas50c', 18, 6);
            $table->decimal('importemonedas20c', 18, 6);
            $table->decimal('importemonedas10c', 18, 6);
            $table->decimal('importetarjetascredito', 18, 6);
            $table->decimal('importetarjetasdebito', 18, 6);
            $table->bigInteger('idturno')->nullable();
            $table->boolean('origen_registro')->nullable();
            $table->decimal('transferencia_electronica', 18, 6)->nullable();
            $table->decimal('vales_electronicos', 18, 6)->nullable();
            $table->decimal('cheques', 18, 6)->nullable();
            $table->decimal('otros', 18, 6)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cortesdecaja');
    }
};
