<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('documentosingresosegresos', function (Blueprint $table) {
            $table->id('iddocument');
            $table->integer('idsucursal');
            $table->bigInteger('iddocumento');
            $table->timestamp('fechadocumento')->nullable();
            $table->string('horadocumento', 11);
            $table->bigInteger('idusuario');
            $table->bigInteger('idconcepto');
            $table->decimal('importedocumento', 18, 6);
            $table->string('referencia', 250);
            $table->string('quien_recibe', 250);
            $table->string('quien_entrega', 250);
            $table->bigInteger('idturno')->nullable();
            $table->smallInteger('estatus')->nullable();
            $table->smallInteger('origen_registro')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('documentosingresosegresos');
    }
};
