<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ing_ventasdetalle01', function (Blueprint $table) {
            $table->id('idweb');
            $table->bigInteger('iddesk');
            $table->integer('idsucursal');
            $table->bigInteger('idventageneral');
            $table->bigInteger('idventageneral_desk')->nullable();
            $table->integer('idusuario')->nullable();
            $table->integer('idusuario_desk')->nullable();
            $table->bigInteger('idproducto')->nullable();
            $table->bigInteger('idfamilia')->nullable();
            $table->bigInteger('idmarca')->nullable();
            $table->decimal('precio', 18, 6);
            $table->decimal('importe', 18, 6);
            $table->decimal('descuentox100', 18, 6);
            $table->decimal('descuento', 18, 6);
            $table->decimal('subtotal', 18, 6);
            $table->decimal('iva', 18, 6);
            $table->decimal('total', 18, 6);
            $table->decimal('precionormal', 18, 6);
            $table->decimal('cantidad', 18, 6);
            $table->decimal('cantidaddevueltaxnc', 18, 6)->nullable();
            $table->string('descripcionadicional', 1000)->nullable();
            $table->string('clave_prodserv', 10)->nullable();
            $table->string('noidentificacion', 100)->nullable();
            $table->string('clave_unidadmedida', 10)->nullable();
            $table->string('unidadmedida', 30)->nullable();
            $table->string('descripcion', 1000)->nullable();
            $table->string('clave_impuesto', 10)->nullable();
            $table->string('impuesto', 10)->nullable();
            $table->string('tasa_factor', 20)->nullable();
            $table->string('clave_tipofactor', 10)->nullable();
            $table->string('tasa_impuesto', 20)->nullable();
            $table->string('tasa_tipo_rango', 20)->nullable();
            $table->decimal('tasa_valor_maximo', 18, 6)->nullable();
            $table->smallInteger('tasa_traslado')->nullable();
            $table->smallInteger('tasa_retencion')->nullable();
            $table->decimal('importe_impuesto', 18, 6)->nullable();
            $table->string('ccb_frombascula', 30)->nullable();
            $table->boolean('origen_registro')->nullable();
            $table->decimal('costo_venta', 18, 6)->nullable();
            $table->decimal('utilidad', 18, 6)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ing_ventasdetalle01');
    }
};
