<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ing_ventasgeneral01', function (Blueprint $table) {
            $table->id('idweb');
            $table->bigInteger('iddesk');
            $table->bigInteger('idsucursal');
            $table->smallInteger('idstatus')->nullable();
            $table->date('fechaventa')->nullable();
            $table->bigInteger('idcliente');
            $table->bigInteger('idcliente_desk')->nullable();
            $table->string('cliente', 50)->nullable();
            $table->integer('idtipodocumento')->nullable();
            $table->string('tipodocumento', 80);
            $table->integer('numerodocumento');
            $table->timestamp('fechahoradocumento')->nullable();
            $table->boolean('pagado');
            $table->bigInteger('idtipopago')->nullable();
            $table->bigInteger('idtipopago_desk')->nullable();
            $table->string('tipopago', 20);
            $table->string('referencia', 80);
            $table->string('comentarios', 300);
            $table->bigInteger('idusuario')->nullable();
            $table->bigInteger('idusuario_desk')->nullable();
            $table->string('usuario', 50)->nullable();
            $table->decimal('totalventa', 18, 6);
            $table->decimal('descuentox100', 18, 6);
            $table->decimal('descuento', 18, 6);
            $table->decimal('subtotal', 18, 6);
            $table->decimal('iva', 18, 6);
            $table->decimal('totalapagar', 18, 6);
            $table->decimal('totalentregado', 18, 6);
            $table->decimal('cambioaentregar', 18, 6);
            $table->decimal('comision', 18, 6)->default(-1);
            $table->decimal('total_retencion_iva', 18, 6);
            $table->decimal('total_retencion_isr', 18, 6);
            $table->string('observaciones1', 50);
            $table->string('observaciones2', 50);
            $table->bigInteger('foliodocumento')->nullable();
            $table->bigInteger('idturno')->nullable();
            $table->bigInteger('idturno_desk')->nullable();
            $table->bigInteger('idpedidogeneral')->nullable();
            $table->bigInteger('idpedidogeneral_desk')->nullable();
            $table->decimal('total_cobrado', 18, 6)->nullable();
            $table->decimal('total_xcobrar', 18, 6)->nullable();
            $table->timestamp('fechahora_registro')->nullable()->nullable();
            $table->string('from_host', 50)->nullable();
            $table->string('origen_movimiento', 50)->nullable();
            $table->decimal('costototal', 18, 6)->nullable()->default(0);
            $table->decimal('utilidadtotal', 18, 6)->nullable()->default(0);
            $table->boolean('origen_registro')->nullable();
            $table->decimal('total_retencion_regulada', 18, 6)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ing_ventasgeneral01');
    }
};
