<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ing_ventasgeneral', function (Blueprint $table) {
            $table->id('idgeneralsale');
            $table->bigInteger('idsucursal');
            $table->bigInteger('idventageneral');
            $table->integer('idstatus');
            $table->date('fechaventa')->nullable();
            $table->bigInteger('idcliente');
            $table->string('cliente', 180)->nullable();
            $table->integer('idtipodocumento');
            $table->string('numerodocumento', 20);
            $table->date('fechadocumento')->nullable();
            $table->string('horadocumento', 8);
            $table->smallInteger('pagado');
            $table->bigInteger('idtipopago');
            $table->string('tipopago', 30)->nullable();
            $table->binary('comentarios')->nullable();
            $table->bigInteger('idusuario');
            $table->decimal('totalventa', 18, 6);
            $table->decimal('descuentox100', 18, 6);
            $table->decimal('descuento', 18, 6);
            $table->decimal('subtotal', 18, 6);
            $table->decimal('iva', 18, 6);
            $table->decimal('totalapagar', 18, 6);
            $table->decimal('totalentregado', 18, 6);
            $table->decimal('cambioaentregar', 18, 6);
            $table->decimal('comision', 18, 6)->default(-1);
            $table->decimal('total_retencion_iva', 18, 6);
            $table->decimal('total_retencion_isr', 18, 6);
            $table->string('observaciones1', 50);
            $table->string('observaciones2', 50);
            $table->timestamp('fechahoradocumento')->useCurrentOnUpdate()->useCurrent();
            $table->bigInteger('foliodocumento')->nullable();
            $table->bigInteger('idturno')->nullable();
            $table->bigInteger('idpedidogeneral')->nullable();
            $table->decimal('total_cobrado', 18, 6)->nullable();
            $table->decimal('total_xcobrar', 18, 6)->nullable();
            $table->timestamp('fechahora_registro')->nullable();
            $table->string('usuario', 50)->nullable();
            $table->decimal('costototal', 18, 6)->nullable();
            $table->decimal('utilidadtotal', 18, 6)->nullable();
            $table->string('from_host', 50)->nullable();
            $table->string('origen_movimiento', 50)->nullable();
            $table->smallInteger('descargado')->nullable();
            $table->string('origen_registro', 15)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ing_ventasgeneral');
    }
};
