<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mov_changes', function (Blueprint $table) {
            $table->id('idchange');
            $table->bigInteger('idsucursal');
            $table->bigInteger('identable');
            $table->string('accion', 10);
            $table->string('tabla', 50);
            $table->timestamp('fecha_hora')->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mov_changes');
    }
};
