<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mov_inv_detalle', function (Blueprint $table) {
            $table->id('idmovinventariodet');
            $table->integer('idsucursal');
            $table->bigInteger('idmovinventariodet_desk')->nullable();
            $table->bigInteger('idinventariofisicodet')->nullable();
            $table->bigInteger('idinventariofisicogral');
            $table->bigInteger('idproducto');
            $table->bigInteger('idfamilia')->nullable();
            $table->bigInteger('idmarca')->nullable();
            $table->string('justificacion', 120);
            $table->decimal('costoinventario', 18, 6);
            $table->integer('idsucursal_local');
            $table->decimal('cantidad', 18, 6)->nullable();
            $table->bigInteger('folio_lote_entrada')->nullable();
            $table->string('lote_entrada', 20)->nullable();
            $table->decimal('existencia', 18, 6)->nullable();
            $table->decimal('fisico', 18, 6)->nullable();
            $table->decimal('faltante', 18, 6)->nullable();
            $table->decimal('excedente', 18, 6)->nullable();
            $table->bigInteger('idalmacen');
            $table->integer('idsucursal_web_origen')->nullable();
            $table->integer('idsucursal_web_destino')->nullable();
            $table->string('origen_registro', 15)->nullable();
            $table->smallInteger('descargado')->nullable();
            $table->string('nombre_corto_producto', 30)->nullable();
            $table->timestamp('fecha_hora')->nullable();
            $table->string('clave_familia', 20)->nullable();
            $table->string('clave_marca', 20)->nullable();
            $table->integer('idconceptoinventario')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mov_inv_detalle');
    }
};
