<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pedidos_detalle_01', function (Blueprint $table) {
            $table->id('idweb');
            $table->bigInteger('iddesk');
            $table->bigInteger('idsucursal');
            $table->smallInteger('origen_registro')->nullable()->default(0);
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable();
            $table->bigInteger('idpedidogeneral');
            $table->bigInteger('idproducto');
            $table->string('clave', 30);
            $table->string('descripcion', 254);
            $table->string('unidadmedida', 30);
            $table->decimal('cantidad', 18, 6);
            $table->decimal('precio', 18, 6);
            $table->decimal('importe', 18, 6);
            $table->decimal('descuentox100', 18, 6);
            $table->decimal('descuento', 18, 6);
            $table->decimal('subtotal', 18, 6);
            $table->decimal('iva', 18, 6);
            $table->decimal('total', 18, 6);
            $table->smallInteger('productoyavendido');
            $table->decimal('cantidadfaltantexvender', 18, 6);
            $table->string('descripcionadicional', 100)->nullable();
            $table->smallInteger('cancelado');
            $table->string('justificacion_cancelacion', 254);
            $table->decimal('cantidadyaenviada', 18, 6)->nullable();
            $table->decimal('cantidadxenviar', 18, 6)->nullable();
            $table->bigInteger('idalmacen')->nullable();
            $table->decimal('costopromedio', 18, 6)->nullable();
            $table->timestamp('fechahoradocumento')->nullable();
            $table->bigInteger('idfamilia')->nullable();
            $table->string('clave_familia', 20)->nullable();
            $table->bigInteger('idmarca')->nullable();
            $table->string('clave_marca', 20)->nullable();
            $table->bigInteger('idusuario')->nullable();
            $table->string('usuario', 50)->nullable();
            $table->bigInteger('idturno')->nullable();
            $table->string('traslado_iva_tipo_factor', 20)->nullable();
            $table->decimal('traslado_iva_tasa_cuota', 18, 6)->nullable();
            $table->decimal('traslado_iva_importe', 18, 6)->nullable();
            $table->string('traslado_ieps_tipo_factor', 20)->nullable();
            $table->decimal('traslado_ieps_tasa_cuota', 18, 6)->nullable();
            $table->decimal('traslado_ieps_importe', 18, 6)->nullable();
            $table->string('retencion_iva_tipo_factor', 20)->nullable();
            $table->decimal('retencion_iva_tasa_cuota', 18, 6)->nullable();
            $table->decimal('retencion_iva_importe', 18, 6)->nullable();
            $table->string('retencion_isr_tipo_factor', 20)->nullable();
            $table->decimal('retencion_isr_tasa_cuota', 18, 6)->nullable();
            $table->decimal('retencion_isr_importe', 18, 6)->nullable();
            $table->decimal('peso_bruto', 18, 6)->nullable();
            $table->decimal('peso_tara', 18, 6)->nullable();
            $table->decimal('peso_agua', 18, 6)->nullable();
            $table->decimal('peso_neto', 18, 6)->nullable();
            $table->decimal('peso_promedio', 18, 6)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pedidos_detalle_01');
    }
};
